/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.managedsystem.fru;

import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.managedsystem.fru.FruListController;
import com.ibm.hwmca.fw.service.managedsystem.fru.FruListControllerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PIFruListController
implements FruListController {
    public void modify(Fru fru, int modType, Map userData) throws FruListControllerException {
        if (fru != null) {
            Map props = fru.getProperties();
            switch (modType) {
                case 0: 
                case 1: {
                    ArrayList<Fru> listOfOne = new ArrayList<Fru>(1);
                    listOfOne.add(fru);
                    this.modify(listOfOne, 1, userData);
                    break;
                }
                case 2: {
                    this.removeFru(fru, userData);
                    break;
                }
                default: {
                    throw new FruListControllerException("Unsupported FRU list modification type: " + modType);
                }
            }
        }
    }

    public void modify(List frus, int modType, Map userData) throws FruListControllerException {
        if (frus != null) {
            Object[] array = frus.toArray();
            switch (modType) {
                case 0: 
                case 1: {
                    for (int aii = array.length; aii > 0; --aii) {
                        this.removeFru((Fru)array[aii - 1], userData);
                    }
                    Vector fruList = (Vector)userData.get("FRU_LIST");
                    if (fruList == null) {
                        fruList = new Vector();
                        userData.put("FRU_LIST", fruList);
                    }
                    Iterator it = fruList.iterator();
                    while (it.hasNext()) {
                        Fru fru = (Fru)it.next();
                        Map fruProps = fru.getProperties();
                        Integer exchangeBlock = (Integer)fruProps.get("EXCHANGE_BLOCK");
                        if (exchangeBlock == null) continue;
                        fruProps.put("EXCHANGE_BLOCK", new Integer(exchangeBlock + 1));
                        fru.setProperties(fruProps);
                    }
                    for (int aii = array.length; aii > 0; --aii) {
                        Fru fru = (Fru)array[aii - 1];
                        Map fruProps = fru.getProperties();
                        fruProps.put("EXCHANGE_BLOCK", new Integer(0));
                        fru.setProperties(fruProps);
                        this.moveFruToFront((Fru)array[aii - 1], userData);
                    }
                    break;
                }
                case 2: {
                    for (int aii = array.length; aii > 0; --aii) {
                        this.removeFru((Fru)array[aii - 1], userData);
                    }
                    break;
                }
                default: {
                    throw new FruListControllerException("Unsupported FRU list modification type: " + modType);
                }
            }
        }
    }

    protected void moveFruToFront(Fru fru, Map userData) throws FruListControllerException {
        if (fru != null) {
            Map props = fru.getProperties();
            Vector<Fru> fruList = (Vector<Fru>)userData.get("FRU_LIST");
            if (fruList == null) {
                fruList = new Vector<Fru>();
            }
            fruList.remove(fru);
            fruList.add(0, fru);
            userData.put("FRU_LIST", fruList);
            props.put("SELECTED", Boolean.FALSE);
            props.put("EXCHANGED", Boolean.FALSE);
            fru.setProperties(props);
        }
    }

    protected void removeFru(Fru fru, Map userData) throws FruListControllerException {
        if (fru != null) {
            Map props = fru.getProperties();
            Vector fruList = (Vector)userData.get("FRU_LIST");
            if (fruList == null) {
                fruList = new Vector();
            }
            fruList.remove(fru);
            userData.put("FRU_LIST", fruList);
        }
    }
}

